<?php
extract( $atts );

$classes = array( 
	'lqd-testi',
	$this->get_classes( $template ), 

	$el_class, 
	$this->get_id() 
);

$this->generate_css();

?>
<div id="<?php echo $this->get_id() ?>" class="<?php echo ld_helper()->sanitize_html_classes( $classes ) ?>">

	<div class="lqd-testi-extra mt-2 mb-4">

		<svg class="lqd-testi-quote-icon lqd-testi-quote-icon-flip" xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 48 48">
			<circle cx="24" cy="24" r="24"/>
			<path d="M33.6506355,22.4458786 C34.1870129,24.3649793 34.1999448,26.4569702 33.6852534,28.1856729 C33.115054,30.1017893 31.9414302,31.3977692 30.3804449,31.8340732 C29.9875127,31.9440942 29.5828423,32 29.177575,32 C27.1880449,32 25.4239286,30.6602504 24.8875513,28.7425424 C24.2258336,26.3757974 25.612536,23.9115654 27.9796789,23.2492508 C29.0289571,22.9569888 30.1876594,23.0682036 31.158948,23.5488741 C31.1277124,23.417963 31.0952831,23.2924236 31.0610632,23.1696696 C30.1958165,20.0761493 28.4985484,18.684274 27.5698357,18.684274 L27.5288514,18.6850698 C27.3503906,18.6932269 27.1786941,18.5728603 27.1289559,18.3947974 L26.6134686,16.5509009 C26.5830288,16.4426704 26.5999398,16.3268798 26.6598247,16.2315813 C26.7199085,16.1368797 26.8169976,16.0716231 26.9280133,16.0521257 C27.1237831,16.0175079 27.3247256,16 27.5258671,16 C30.0300887,16 32.6063312,18.7111327 33.6506355,22.4458786 Z M17.2027923,16.0003979 C19.7076107,16.0003979 22.2834553,18.7111327 23.3283565,22.4454807 C23.8649328,24.3647803 23.8776658,26.4569702 23.3631733,28.1856729 C22.792775,30.1017893 21.6191512,31.3977692 20.0583649,31.8340732 C19.6652337,31.9440942 19.2605633,32 18.855296,32 C16.8657659,32 15.1016496,30.6602504 14.5652723,28.7425424 C13.9031566,26.3757974 15.290257,23.9115654 17.657002,23.2492508 C18.7062802,22.9569888 19.8645846,23.0682036 20.8362711,23.5488741 C20.8052345,23.4187588 20.7728051,23.2932194 20.7383862,23.1696696 C19.8731396,20.0761493 18.1756725,18.684274 17.2469599,18.684274 L17.2063735,18.6850698 C17.0247294,18.6932269 16.8562162,18.5728603 16.8064779,18.3947974 L16.2907917,16.5509009 C16.2605509,16.4426704 16.2774619,16.3268798 16.3373467,16.2315813 C16.3972316,16.1368797 16.4945196,16.0712252 16.6053364,16.0521257 C16.8009072,16.0175079 17.0020487,16.0003979 17.2027923,16.0003979 Z"/>
		</svg>

	</div><!-- /.lqd-testi-extra -->

	<div class="lqd-testi-quote mb-6">
		<?php $this->get_quote(); ?>
	</div><!-- /.lqd-testi-quote -->

	<div class="lqd-testi-info mb-1">

		<div class="lqd-testi-details d-flex flex-column">
			<?php $this->get_avatar( 'mx-0 mb-2' ) ?>
			<div class="lqd-testi-np">
				<?php $this->get_name( 'h3', 'font-weight-medium' ) ?>
				<?php $this->get_position() ?>
			</div><!-- /.lqd-testi-np -->

		</div><!-- /.lqd-testi-details -->

	</div><!-- /.lqd-testi-info -->
	
</div><!-- /.lqd-testi lqd-testi-card -->